#include "arp.h"

void ArpOperations::ReadArpTable(CEdit & edit)
{
	MIB_IPNETTABLE * ipNetTable = NULL;
	ULONG pdwSize = 0;
	CString text;
	
	GetIpNetTable(ipNetTable,&pdwSize,true);
	ipNetTable = (MIB_IPNETTABLE*)malloc(pdwSize);
	
	if(GetIpNetTable(ipNetTable,&pdwSize,true) == NO_ERROR)
	{
		for(int i=0;i<ipNetTable->dwNumEntries;i++)
		{
			wchar_t * typ = ArpOperations::Type(ipNetTable->table[i].dwType);
			CString macStr;
			macStr.AppendFormat(L"%02x-%02x-%02x-%02x-%02x-%02x", 
				ipNetTable->table[i].bPhysAddr[0],
				ipNetTable->table[i].bPhysAddr[1],
				ipNetTable->table[i].bPhysAddr[2],
				ipNetTable->table[i].bPhysAddr[3],
				ipNetTable->table[i].bPhysAddr[4],
				ipNetTable->table[i].bPhysAddr[5]);

			
			in_addr addr;
			addr.s_addr = ipNetTable->table[i].dwAddr;
			char * szAddr = inet_ntoa(addr);
			wchar_t  szAddrWide[16] = {'\0'};
            mbstowcs(szAddrWide,szAddr,16);
			text.AppendFormat(L"Adres IP:%s\r\nAdres fizyczny:%s\r\nTyp:%s\r\n",szAddrWide,macStr,typ);
			edit.SetWindowTextW(text);
		}
	}
	if(ipNetTable != NULL)
	{
		free(ipNetTable);
	}
}

void ArpOperations::ReadArpTable2(CEdit & edit)
{
	MIB_IPNETTABLE * ipNetTable = NULL;
	ULONG pdwSize = 0;
	CString text;
	
	GetIpNetTable(ipNetTable,&pdwSize,true);
	ipNetTable = (MIB_IPNETTABLE*)malloc(pdwSize);
	
	if(GetIpNetTable(ipNetTable,&pdwSize,true) == NO_ERROR)
	{

		MIB_IPADDRTABLE * ipAddrTable = NULL;
		ULONG pdwSizeAddr = 0;
		GetIpAddrTable(ipAddrTable,&pdwSizeAddr,true);
		ipAddrTable = (MIB_IPADDRTABLE *)malloc(pdwSizeAddr);

		if(GetIpAddrTable(ipAddrTable,&pdwSizeAddr,true) == NO_ERROR)
		{

			for(int j=0;j<ipAddrTable->dwNumEntries;j++)
			{
				for(int i=0;i<ipNetTable->dwNumEntries;i++)
				{
					if(ipAddrTable->table[j].dwIndex == ipNetTable->table[i].dwIndex)
					{
						in_addr addr_i;
						addr_i.s_addr = ipAddrTable->table[j].dwAddr;
						char * szAddr_i = inet_ntoa(addr_i);
						wchar_t  szAddrWide_i[16] = {'\0'};
						mbstowcs(szAddrWide_i,szAddr_i,16);
						text.AppendFormat(L"Interfejs:%s ---%d\r\n",szAddrWide_i,ipAddrTable->table[j].dwIndex);


						wchar_t * typ = ArpOperations::Type(ipNetTable->table[i].dwType);
						CString macStr;
						macStr.AppendFormat(L"%02x-%02x-%02x-%02x-%02x-%02x", 
						ipNetTable->table[i].bPhysAddr[0],
						ipNetTable->table[i].bPhysAddr[1],
						ipNetTable->table[i].bPhysAddr[2],
						ipNetTable->table[i].bPhysAddr[3],
						ipNetTable->table[i].bPhysAddr[4],
						ipNetTable->table[i].bPhysAddr[5]);

				
						in_addr addr;
						addr.s_addr = ipNetTable->table[i].dwAddr;
						char * szAddr = inet_ntoa(addr);
						wchar_t  szAddrWide[16] = {'\0'};
						mbstowcs(szAddrWide,szAddr,16);
						text.AppendFormat(L"Adres IP:%s\r\nAdres fizyczny:%s\r\nTyp:%s\r\n",szAddrWide,macStr,typ);
						edit.SetWindowTextW(text);
					}
				}
			}
		}
		free(ipAddrTable);
	}
	if(ipNetTable != NULL)
	{
		free(ipNetTable);
	}
}

wchar_t * ArpOperations::Type(int type)
{
	switch(type)
	{
	case 4:
		return L"statyczny";
	case 3:
		return L"dynamiczny";
	case 2:
		return L"niepoprawny";
	default:
		return L"inny";

	}
}